require 'json'
require 'fileutils'
require './Utils'
require 'pathname'
require 'shellwords'

current = Pathname.new(File.dirname(__FILE__)).realpath
system "clear;cat #{current}/readme.md | tail -n 17  |  head -n 100"

def readPrototypeKey(file, keyName)
  link = Shellwords.escape(file)
  %x{defaults read #{link} #{keyName}}.chomp
end

def parseAppInfo(appBaseLocate, appInfoFile)
  appInfo = {}
  appInfo['appBaseLocate'] = "#{appBaseLocate}"
  appInfo['CFBundleIdentifier'] = readPrototypeKey appInfoFile, 'CFBundleIdentifier'
  appInfo['CFBundleVersion'] = readPrototypeKey appInfoFile, 'CFBundleVersion'
  appInfo['CFBundleShortVersionString'] = readPrototypeKey appInfoFile, 'CFBundleShortVersionString'
  appInfo['CFBundleName'] = readPrototypeKey appInfoFile, 'CFBundleExecutable'
  appInfo
end

def scan_apps
  applist = []
  baseDir = '/Applications'
  lst = Dir.glob("#{baseDir}/Para*")
  lst.each do |app|
    appInfoFile = "#{app}/Contents/Info.plist"
    next unless File.exist?(appInfoFile)
    begin
      applist.push parseAppInfo app, appInfoFile
    #   puts "Check the local App: #{appInfoFile}"
    rescue StandardError
      next
    end
  end
  applist
end

def checkCompatible(compatibleVersionCode, compatibleVersionSubCode, appVersionCode, appSubVersionCode)
  return true if compatibleVersionCode.nil? && compatibleVersionSubCode.nil?
  compatibleVersionCode&.each do |code|
    return true if appVersionCode == code
  end

  compatibleVersionSubCode&.each do |code|
    return true if appSubVersionCode == code
  end
  false
end

def main
  puts "Environment Prepare Setting..."

  ret = %x{csrutil status}.chomp
  # System Integrity Protection status: disabled.
  unless ret.include?("status: disabled")
    puts "Turn off your  SIP to install!Is it necessary to turn off SIP? \nIt is written in the requirements to turn off the SIP first, can you please read the instructions I wrote? \nIf you read it and still haven't turned it off, it means you are indeed a dumbass\nIf you didn't read the instructions, then you are even more an dumbass."
    return
  end

  puts "====\tAutomatic injection script starts execution ====\n"
  puts "\tDesign By QiuChenly ( using the new libInjectLib.dylib Thu June 15, 2023)"
  puts "When injecting, please follow the prompts to enter\n"

  install_apps = scan_apps
  
  config = File.read("config.json")
  config = JSON.parse config
  basePublicConfig = config['basePublicConfig']
  appList = config['AppList']
  
    #prepare resolve package lst
  appLst = []
  appList.each do |app|
    packageName = app['packageName']
    if packageName.is_a?(Array)
      packageName.each { |name|
        tmp = app.dup
        tmp['packageName'] = name
        appLst.push tmp
      }
    else
      appLst.push app
    end
  end  
  
  appLst.each { |app|
    packageName = app['packageName']
    appBaseLocate = app['appBaseLocate']
    bridgeFile = app['bridgeFile']
    injectFile = app['injectFile']
    supportVersion = app['supportVersion']
    supportSubVersion = app['supportSubVersion']
    extraShell = app['extraShell']

    localApp = install_apps.select { |_app| _app['CFBundleIdentifier'] == packageName }
    if localApp.empty? && (appBaseLocate.nil? || !Dir.exist?(appBaseLocate))
      next
    end

    if localApp.empty?
      print  "This App package is not on the right place, please note that the path of the current App injection has to be  #{appBaseLocate}"
      # puts "Read by #{appBaseLocate + "/Contents/Info.plist"}"
      localApp.push(parseAppInfo appBaseLocate, appBaseLocate + "/Contents/Info.plist")
    end

    localApp = localApp[0]
    if appBaseLocate.nil?
      appBaseLocate = localApp['appBaseLocate']
    end
    bridgeFile = basePublicConfig['bridgeFile'] if bridgeFile.nil?

    unless checkCompatible(supportVersion, supportSubVersion, localApp['CFBundleShortVersionString'], localApp['CFBundleVersion'])
      puts "[#{localApp['CFBundleName']}] - [#{localApp['CFBundleShortVersionString']}] - [#{localApp['CFBundleIdentifier']}]Not a supported version, skip injection \n"
      next
    end

    print  "[#{localApp['CFBundleName']}] - [#{localApp['CFBundleShortVersionString']}] - [#{localApp['CFBundleIdentifier']}]\nThis is a supported version and does it need to be injected? y/n (Default n) "
    action = gets.chomp
    next if action != 'y'
    puts "Begin injection App: #{packageName}"
    
    dest = appBaseLocate + bridgeFile + injectFile
    backup = dest + "_backup"

    if File.exist? backup
      print  "The injection file already exists. Backup the existing injection file? y/n  (Default y) "
      action = gets.chomp
      # action = 'y'
      if action == 'n'
        FileUtils.remove(backup)
        FileUtils.copy(dest, backup)
      else

      end
    else
      FileUtils.copy(dest, backup)
    end

    current = Pathname.new(File.dirname(__FILE__)).realpath
    current = Shellwords.escape(current)
    # set shell +x permission
    sh = "chmod +x #{current}/tool/insert_dylib"
    # puts sh
    system sh
    backup = Shellwords.escape(backup)
    dest = Shellwords.escape(dest)
    sh = "sudo #{current}/tool/insert_dylib #{current}/tool/libInjectLib.dylib #{backup} #{dest}"
    # puts sh
    system sh
    sh = "codesign -f -s - --timestamp=none --all-architectures #{dest}"
    system sh
    sh = "sudo defaults write /Library/Preferences/com.apple.security.libraryvalidation.plist DisableLibraryValidation -bool true"
    system sh

    unless extraShell.nil?
      system "sudo sh #{current}/tool/" + extraShell
    end
  }
end

main

ret = %x{csrutil status}.chomp
# System Integrity Protection status: disabled.
unless ret.include?("status: enabled")
current = Pathname.new(File.dirname(__FILE__)).realpath
system "sh #{current}/tool/Translation.sh"
  return
end

  